/*
	The Internet class controls access to the wifi and credential collection.
*/

#include "Arduino.h"
#include "WiFi.h"
#include "WiFiClient.h"
#include "WiFiAP.h"

#include "Preferences.h" //Storage for NVS see: https://github.com/espressif/arduino-esp32/tree/master/libraries/Preferences
#include "Utils.h"
#include "Internet.h"




Preferences preferences;

WiFiServer server(80);



Internet::Internet(int test){
   _ssid = "";
   _pw = "";
}

void Internet::init(){
	Serial.println("________________________________________________");
	Serial.println("Initializing Internet Class");

	_ssid = getSSID();
	_pw = getPW();
	Serial.println("Stored SSID: " + _ssid + " PW: " + _pw);


	if(!_ssid || _ssid.length() == 0){
		Serial.println("No wifi credentials are stored.");
		// startCredentialCollection();
	}
	else{
		connectToWifi(0);
	}


}

bool Internet::isConnected(){
	return (WiFi.status() == WL_CONNECTED);
}



String Internet::checkInRequest(String postData){

	if(isConnected() == false){
		Serial.println("Internet not connected.");
		return "-1";
	}


	bool isBody = false;
	String body = "";

	WiFiClient client;

    // const int httpPort = 3000;
    // const char * host = "192.168.1.15";
    // const char * url = "/checkin";

    const int httpPort = 80;
    const char * host = "evening-springs-85319.herokuapp.com";
    const char * url = "/checkin/update";

    if (!client.connect(host, httpPort)) {
        Serial.println("Request failed");
        return "-1";
    } 


    String request = String("POST ") + url + " HTTP/1.1\r\n" +
             "Host: " + host + ":" + httpPort + "\r\n" +
             "Content-Type: application/json\r\n" +
             "Content-Length: " + postData.length() + "\r\n"
             "Connection: close\r\n\r\n" +  
             postData;

    // Serial.println(request);
    client.print(request);

    unsigned long timeout = millis();
    while (client.available() == 0) {
        if (millis() - timeout > 9000) {
            Serial.println(">>> Web Request Client Timeout !");
            client.stop();
            return "-1";
        }
    }

    // Read all the lines of the reply from server and print them to Serial
    while(client.available()) {
        String line = client.readStringUntil('\r');

        if(line == "\n"){
        	//Empty line indicates that the next line is part of the body.
        	// Serial.println("next line is empty line:");
        	isBody = true;
        }

        if(isBody == true){
        	body += line;
        }

        // Serial.print(line);
    }

    // Serial.println("web request done, closing connection");

    // Serial.println("Body is:");
    Serial.println(body);

    return body;

}



void Internet::connectToWifi(int retryCount){

	Serial.print("Connecting to " + _ssid);

	int count = 0;

	WiFi.begin(Utils::stringToCharPointer(_ssid), Utils::stringToCharPointer(_pw) );

	//Wait until we are connected, up to 5 seconds.
	while (WiFi.status() != WL_CONNECTED && count < 20) {
        delay(500);
        Serial.print(".");
        count++;
    }

    if(WiFi.status() != WL_CONNECTED){
    	Serial.println("Unable to connect.");

    	if(retryCount < 10){
    		Serial.println("Trying again..");
	    	connectToWifi(retryCount+1);	
    	}
    	else{
    		Serial.println("Tried to connect too many times, erasing ssid and pw from storage.");
    		setSSID("");
    		setPW("");
    		init();
    	}
    	
    }
    else{
    	Serial.println("Connected to " + _ssid);
    	Serial.println("IP address: ");
    	Serial.println(WiFi.localIP());

    }

}

void Internet::startCredentialCollection(){
	WiFi.softAP("Mushroom Nursery", NULL);
	IPAddress myIP = WiFi.softAPIP();
	Serial.print("Mushoorm AP started at IP address: ");
	Serial.println(myIP);

	server.begin();
  	Serial.println("Credential Server started.");
  	runServer();

  	Serial.println("Credentials collected.");

  	setSSID(_ssid);
  	setPW(_pw);

  	init();

}




//Save the SSID in non volatile storage.
void Internet::setSSID(String ssid){

	//Open wifi-data namespace in write mode.
	preferences.begin("wifi-data", false);

	preferences.putString("ssid", ssid);

	preferences.end();

}

//Save the PW in non volatile storage.
void Internet::setPW(String pw){

	//Open wifi-data namespace in write mode.
	preferences.begin("wifi-data", false);

	preferences.putString("pw", pw);

	preferences.end();

}

//Fetch SSID from non volatile storage
String Internet::getSSID(){

	//Open wifi-data namespace in read only mode.
	preferences.begin("wifi-data", true);

	//Get ssid
	String ssid = preferences.getString("ssid", "");

	preferences.end();

	return ssid;

}

//Fetch PW from non volatile storage
String Internet::getPW(){

	//Open wifi-data namespace in read only mode.
	preferences.begin("wifi-data", true);

	//Get pw
	String pw = preferences.getString("pw", "");

	preferences.end();

	return pw;

}



//Runs the Wifi Credential Collection Server
//Request are expected in this format:
//	http://192.168.4.1/?ssid=myWifiSSID&action=ssid
//	http://192.168.4.1/?pw=123&action=pw
void Internet::runServer(){

	String ssid = "";
	String pw = "";

	while(true){

		WiFiClient client = server.available();   // listen for incoming clients

		//New connection
		if(client){

			Serial.println("New Connection.");

			String received = "";

			while(client.connected()){

				if(client.available()){ //Incoming data from client

					//Read the byte from the client
					char c = client.read();
					// Serial.write(c);

					if(c == '\n') {

						if(received.length() == 0) { 
							//Indicates we received two newlines in a row. Ready for response.

						    client.println("HTTP/1.1 200 OK");
						    client.println("Content-type:text/html");
						    client.println();

						    client.print("<h1>Mushroom Nursery - Setup WiFi Connection</h1><p>Please enter WiFi credentials below:</p><input type='text' placeholder='SSID' id='ssid'></input><br><input type='password' placeholder='Password or empty' id='pw'></input><br><br><button type='button' onclick='update()'>Submit</button><script>	function update(){		var ssid = document.getElementById('ssid').value;		var pw = document.getElementById('pw').value;		if(!ssid){			alert('SSID is required.');			return;		}		request('http://192.168.4.1/?ssid=' + ssid + '&action=ssid');		request('http://192.168.4.1/?pw=' + pw + '&action=pw')	}	function request(url){		var req = new XMLHttpRequest();		req.open('GET', url);		req.send();	}</script>");

						    // HTTP response ends with newline.
						    client.println();

						    break;

						}
						else {    // if you got a newline, then clear received line:
							received = "";
						}


					} 
					else if (c != '\r') { 
						//Received an actual char, add it to received line.
						received += c;      
					}


					//Check if SSID was submitted in request.
					if (received.startsWith("GET") && received.endsWith("&action=ssid")) {
					  	
					  	//Parse the new ssid.
					  	received.replace("GET /?ssid=", ""); 
					  	received.replace("&action=ssid", "");
					  	ssid = received;

					  	Serial.println("SSID is:" + ssid);

					}

					//Check if PW was submitted in request.
					if (received.startsWith("GET") && received.endsWith("&action=pw")) {
					  	
					  	//Parse the pw
					  	received.replace("GET /?pw=", ""); 
					  	received.replace("&action=pw", "");
					  	pw = received;

					  	Serial.println("PW is:" + pw);

					}

				} 

			}

			client.stop();
			Serial.println("Client Disconnected.");

		}

		delay(500);

		//If we collected an ssid and pw then we are done.
		if(ssid != "" && pw != ""){
			
			_ssid = ssid;
			_pw = pw;

			Serial.println("Collected ssid = " + _ssid + " , Collected PW = " + _pw);

			break; //Exits the while loop that keeps the WiFi AP active.
		}

	}

}

